
import { useState } from 'react';
import { Header } from '@/components/Header';
import { Navigation } from '@/components/Navigation';
import { FeaturedMenu } from '@/components/FeaturedMenu';
import { AboutSection } from '@/components/AboutSection';
import { Testimonials } from '@/components/Testimonials';
import { Footer } from '@/components/Footer';

const Index = () => {
  const [lang, setLang] = useState<'en' | 'ar'>('en');

  return (
    <div className="min-h-screen">
      <Navigation lang={lang} onLanguageChange={setLang} />
      <div className="pt-16">
        <Header lang={lang} />
        <AboutSection lang={lang} />
        <FeaturedMenu lang={lang} />
        <Testimonials lang={lang} />
      </div>
      <Footer lang={lang} />
    </div>
  );
};

export default Index;
