
import { useState } from 'react';
import { Navigation } from '@/components/Navigation';
import { Footer } from '@/components/Footer';
import { motion } from 'framer-motion';
import { Building, Users, Award, Clock } from 'lucide-react';

const About = () => {
  const [lang, setLang] = useState<'en' | 'ar'>('en');

  const content = {
    en: {
      title: "Our Story",
      description: "Since 1990, Beit Meryam has been serving authentic cuisine that celebrates our rich culinary heritage. What started as a small family restaurant has grown into a beloved destination for food lovers, while maintaining the warmth and personal touch that makes every guest feel at home.",
      highlights: [
        {
          icon: Building,
          title: "Traditional Setting",
          description: "Authentic atmosphere that reflects our heritage"
        },
        {
          icon: Users,
          title: "Family Legacy",
          description: "Three generations of culinary expertise"
        },
        {
          icon: Award,
          title: "Quality First",
          description: "Using only the finest ingredients"
        },
        {
          icon: Clock,
          title: "Timeless Recipes",
          description: "Traditional recipes passed down through generations"
        }
      ]
    },
    ar: {
      title: "قصتنا",
      description: "منذ عام 1990، يقدم بيت مريم أطباقاً أصيلة تحتفي بتراثنا الطهي الغني. ما بدأ كمطعم عائلي صغير نما ليصبح وجهة محبوبة لعشاق الطعام، مع الحفاظ على الدفء واللمسة الشخصية التي تجعل كل ضيف يشعر وكأنه في منزله.",
      highlights: [
        {
          icon: Building,
          title: "أجواء تقليدية",
          description: "أجواء أصيلة تعكس تراثنا"
        },
        {
          icon: Users,
          title: "إرث عائلي",
          description: "ثلاثة أجيال من الخبرة في فن الطهي"
        },
        {
          icon: Award,
          title: "الجودة أولاً",
          description: "نستخدم أجود المكونات فقط"
        },
        {
          icon: Clock,
          title: "وصفات خالدة",
          description: "وصفات تقليدية متوارثة عبر الأجيال"
        }
      ]
    }
  };

  return (
    <div className="min-h-screen" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
      <Navigation lang={lang} onLanguageChange={setLang} />
      <div className="pt-16">
        <div className="relative h-[40vh] overflow-hidden">
          <div 
            className="absolute inset-0 bg-cover bg-center"
            style={{
              backgroundImage: "url('https://images.unsplash.com/photo-1514933651103-005eec06c04b?q=80&w=1974&auto=format&fit=crop')"
            }}
          >
            <div className="absolute inset-0 bg-black/50" />
          </div>
          <div className="relative container h-full flex items-center justify-center">
            <motion.h1 
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              className="text-4xl md:text-5xl font-serif font-bold text-white"
            >
              {content[lang].title}
            </motion.h1>
          </div>
        </div>

        <section className="section-padding">
          <div className="container">
            <motion.div 
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              className="max-w-3xl mx-auto text-center mb-16"
            >
              <p className="text-lg text-secondary leading-relaxed">
                {content[lang].description}
              </p>
            </motion.div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
              {content[lang].highlights.map((highlight, index) => (
                <motion.div
                  key={index}
                  initial={{ opacity: 0, y: 20 }}
                  whileInView={{ opacity: 1, y: 0 }}
                  viewport={{ once: true }}
                  transition={{ delay: index * 0.1 }}
                  className="text-center p-6 rounded-lg bg-accent"
                >
                  <highlight.icon className="w-12 h-12 text-primary mx-auto mb-4" />
                  <h3 className="text-xl font-semibold mb-2">{highlight.title}</h3>
                  <p className="text-secondary">{highlight.description}</p>
                </motion.div>
              ))}
            </div>
          </div>
        </section>
      </div>
      <Footer lang={lang} />
    </div>
  );
};

export default About;
