
import { motion } from 'framer-motion';

interface TestimonialsProps {
  lang: 'en' | 'ar';
}

export const Testimonials = ({ lang }: TestimonialsProps) => {
  const content = {
    en: {
      title: "What Our Guests Say",
      testimonials: [
        {
          text: "The best dining experience I've had in years. The attention to detail and service is impeccable.",
          author: "Sarah Johnson",
          role: "Food Critic"
        },
        {
          text: "A perfect blend of traditional and modern cuisine. Every dish tells a story.",
          author: "Michael Chen",
          role: "Regular Guest"
        },
        {
          text: "The ambiance and food quality are consistently outstanding. A must-visit restaurant.",
          author: "Emma Davis",
          role: "Food Blogger"
        }
      ]
    },
    ar: {
      title: "ماذا يقول ضيوفنا",
      testimonials: [
        {
          text: "أفضل تجربة طعام حظيت بها منذ سنوات. الاهتمام بالتفاصيل والخدمة لا تشوبها شائبة.",
          author: "سارة جونسون",
          role: "ناقدة طعام"
        },
        {
          text: "مزيج مثالي من المطبخ التقليدي والحديث. كل طبق يحكي قصة.",
          author: "مايكل تشن",
          role: "ضيف دائم"
        },
        {
          text: "الأجواء وجودة الطعام رائعة باستمرار. مطعم يستحق الزيارة.",
          author: "إيما ديفيس",
          role: "مدونة طعام"
        }
      ]
    }
  };

  return (
    <section className="section-padding bg-accent/20" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
      <div className="container">
        <motion.h2
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="heading-2 text-center mb-12"
        >
          {content[lang].title}
        </motion.h2>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {content[lang].testimonials.map((testimonial, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.2 }}
              viewport={{ once: true }}
              className="bg-white p-6 rounded-lg shadow-lg"
            >
              <div className="mb-4">
                <svg className="w-8 h-8 text-primary opacity-50" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z" />
                </svg>
              </div>
              <p className="text-lg mb-4">{testimonial.text}</p>
              <div>
                <p className="font-semibold">{testimonial.author}</p>
                <p className="text-sm text-muted-foreground">{testimonial.role}</p>
              </div>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  );
};
