
import { useState } from 'react';
import { Button } from "@/components/ui/button";

type Language = 'en' | 'ar';

interface LanguageSwitcherProps {
  currentLang: Language;
  onLanguageChange: (lang: Language) => void;
}

export const LanguageSwitcher = ({ currentLang, onLanguageChange }: LanguageSwitcherProps) => {
  return (
    <div className="fixed top-4 right-4 z-50">
      <Button
        variant="outline"
        size="sm"
        onClick={() => onLanguageChange(currentLang === 'en' ? 'ar' : 'en')}
        className="min-w-[80px]"
      >
        {currentLang === 'en' ? 'العربية' : 'English'}
      </Button>
    </div>
  );
};
