
import { useState, useEffect } from 'react';
import { motion } from 'framer-motion';
import { Button } from "@/components/ui/button";

interface HeaderProps {
  lang: 'en' | 'ar';
}

export const Header = ({ lang }: HeaderProps) => {
  const content = {
    en: {
      subtitle: "Experience Culinary Excellence",
      cta: "Reserve a Table",
      menuTitle: "Explore Our Menu",
      menuDescription: "Discover our carefully curated selection of authentic dishes",
      viewFullMenu: "View Full Menu",
      learnMore: "Learn More"
    },
    ar: {
      subtitle: "تجربة الطهي المتميزة",
      cta: "احجز طاولة",
      menuTitle: "استكشف قائمتنا",
      menuDescription: "اكتشف مجموعة مختارة بعناية من الأطباق الأصيلة",
      viewFullMenu: "عرض القائمة الكاملة",
      learnMore: "اعرف المزيد"
    }
  };

  return (
    <section className="relative min-h-[90vh] flex items-center justify-center overflow-hidden">
      <div 
        className="absolute inset-0 z-0"
        style={{
          backgroundImage: "url('https://images.unsplash.com/photo-1514933651103-005eec06c04b?q=80&w=1974&auto=format&fit=crop')",
          backgroundPosition: 'center',
          backgroundSize: 'cover',
        }}
      >
        <div className="absolute inset-0 bg-black/40" />
      </div>
      
      <div className="container relative z-10 text-center text-white" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8 }}
          className="max-w-3xl mx-auto"
        >
          <p className="text-xl mb-8 text-white/90 font-arabic">
            {content[lang].subtitle}
          </p>
          <div className="flex flex-col sm:flex-row items-center justify-center gap-4 mb-16">
            <Button 
              size="lg" 
              className="btn-primary text-lg"
              onClick={() => window.location.href = lang === 'ar' ? '/reservation?lang=ar' : '/reservation'}
            >
              {content[lang].cta}
            </Button>
            <Button 
              size="lg" 
              variant="outline"
              className="text-lg bg-white/10 hover:bg-white/20 text-white border-white"
              onClick={() => window.location.href = lang === 'ar' ? '/about?lang=ar' : '/about'}
            >
              {content[lang].learnMore}
            </Button>
          </div>

          <div className="mt-16 bg-black/60 backdrop-blur-sm rounded-xl p-8">
            <h2 className="text-2xl font-bold mb-4 font-arabic">
              {content[lang].menuTitle}
            </h2>
            <p className="mb-6 text-white/80 font-arabic">
              {content[lang].menuDescription}
            </p>
            <Button 
              variant="outline"
              className="text-white border-white hover:bg-white/20"
              onClick={() => window.location.href = lang === 'ar' ? '/menu?lang=ar' : '/menu'}
            >
              {content[lang].viewFullMenu}
            </Button>
          </div>
        </motion.div>
      </div>
    </section>
  );
};
