
import { Facebook, Instagram, Twitter, Youtube } from 'lucide-react';

interface FooterProps {
  lang: 'en' | 'ar';
}

export const Footer = ({ lang }: FooterProps) => {
  const content = {
    en: {
      about: "About CozyBites",
      aboutText: "CozyBites offers an exceptional dining experience with a perfect blend of traditional and modern cuisine.",
      contact: "Contact",
      address: "123 Restaurant Street, Foodie City",
      phone: "+1 234 567 890",
      email: "info@cozybites.com",
      social: "Follow Us",
      rights: "All rights reserved"
    },
    ar: {
      about: "عن كوزي بايتس",
      aboutText: "يقدم كوزي بايتس تجربة طعام استثنائية مع مزيج مثالي من المأكولات التقليدية والحديثة.",
      contact: "اتصل بنا",
      address: "١٢٣ شارع المطعم، مدينة الطعام",
      phone: "٨٩٠ ٥٦٧ ٢٣٤ ١+",
      email: "info@cozybites.com",
      social: "تابعنا",
      rights: "جميع الحقوق محفوظة"
    }
  };

  const socialLinks = [
    { Icon: Facebook, href: "https://facebook.com" },
    { Icon: Instagram, href: "https://instagram.com" },
    { Icon: Twitter, href: "https://twitter.com" },
    { Icon: Youtube, href: "https://youtube.com" }
  ];

  return (
    <footer className="bg-primary text-white" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {/* About Section */}
          <div>
            <h3 className="font-serif text-xl font-bold mb-4">
              {content[lang].about}
            </h3>
            <p className="text-white/80">
              {content[lang].aboutText}
            </p>
          </div>

          {/* Contact Section */}
          <div>
            <h3 className="font-serif text-xl font-bold mb-4">
              {content[lang].contact}
            </h3>
            <div className="space-y-2 text-white/80">
              <p>{content[lang].address}</p>
              <p>{content[lang].phone}</p>
              <p>{content[lang].email}</p>
            </div>
          </div>

          {/* Social Media Section */}
          <div>
            <h3 className="font-serif text-xl font-bold mb-4">
              {content[lang].social}
            </h3>
            <div className="flex space-x-4">
              {socialLinks.map(({ Icon, href }) => (
                <a
                  key={href}
                  href={href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-white/80 hover:text-white transition-colors"
                >
                  <Icon className="w-6 h-6" />
                </a>
              ))}
            </div>
          </div>
        </div>

        <div className="mt-12 pt-4 border-t border-white/20 text-center text-white/60">
          <p>© {new Date().getFullYear()} CozyBites. {content[lang].rights}.</p>
        </div>
      </div>
    </footer>
  );
};
