
import { motion } from 'framer-motion';

interface FeaturedMenuProps {
  lang: 'en' | 'ar';
}

export const FeaturedMenu = ({ lang }: FeaturedMenuProps) => {
  const content = {
    en: {
      title: "Featured Dishes",
      subtitle: "Our Chef's Special Selection",
      items: [
        {
          name: "Mediterranean Grilled Salmon",
          description: "Fresh salmon fillet with herbs and lemon",
          price: "$24.99"
        },
        {
          name: "Truffle Risotto",
          description: "Creamy arborio rice with black truffle",
          price: "$22.99"
        },
        {
          name: "Wagyu Beef Steak",
          description: "Premium grade wagyu with seasonal vegetables",
          price: "$45.99"
        }
      ]
    },
    ar: {
      title: "أطباق مميزة",
      subtitle: "اختيارات الشيف الخاصة",
      items: [
        {
          name: "سلمون مشوي على الطريقة المتوسطية",
          description: "فيليه سلمون طازج مع الأعشاب والليمون",
          price: "24.99$"
        },
        {
          name: "ريزوتو بالكمأة",
          description: "أرز أربوريو كريمي مع الكمأة السوداء",
          price: "22.99$"
        },
        {
          name: "ستيك لحم واغيو",
          description: "لحم واغيو ممتاز مع خضروات موسمية",
          price: "45.99$"
        }
      ]
    }
  };

  return (
    <section className="section-padding bg-muted" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
      <div className="container">
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-12"
        >
          <h2 className="heading-2 mb-4">{content[lang].title}</h2>
          <p className="text-lg text-muted-foreground">{content[lang].subtitle}</p>
        </motion.div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {content[lang].items.map((item, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.2 }}
              viewport={{ once: true }}
              className="bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-xl transition-shadow duration-300"
            >
              <div className="aspect-[4/3] relative">
                <img
                  src={`https://images.unsplash.com/photo-1600${index + 1}-food-${index + 1}?auto=format&fit=crop&w=800`}
                  alt={item.name}
                  className="object-cover w-full h-full"
                />
              </div>
              <div className="p-6">
                <h3 className="heading-3 mb-2">{item.name}</h3>
                <p className="text-muted-foreground mb-4">{item.description}</p>
                <p className="text-xl font-semibold text-primary">{item.price}</p>
              </div>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  );
};
