
import { motion } from 'framer-motion';
import { Button } from '@/components/ui/button';

interface AboutSectionProps {
  lang: 'en' | 'ar';
}

export const AboutSection = ({ lang }: AboutSectionProps) => {
  const content = {
    en: {
      title: "Our Story",
      description: "Founded in 2010, CozyBites has been serving exceptional cuisine that combines traditional flavors with modern culinary techniques. Our passionate team of chefs creates memorable dining experiences using only the finest ingredients.",
      cta: "Learn More"
    },
    ar: {
      title: "قصتنا",
      description: "تأسس مطعم كوزي بايتس في عام 2010، ومنذ ذلك الحين ونحن نقدم مأكولات استثنائية تجمع بين النكهات التقليدية وتقنيات الطهي الحديثة. يقوم فريقنا من الطهاة المتحمسين بإبداع تجارب طعام لا تُنسى باستخدام أجود المكونات.",
      cta: "اعرف المزيد"
    }
  };

  return (
    <section className="section-padding" dir={lang === 'ar' ? 'rtl' : 'ltr'}>
      <div className="container">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <motion.div
            initial={{ opacity: 0, x: -20 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.6 }}
            viewport={{ once: true }}
            className="relative aspect-[4/3] rounded-lg overflow-hidden"
          >
            <img
              src="https://images.unsplash.com/photo-1514933651103-005eec06c04b?q=80&w=1974&auto=format&fit=crop"
              alt="Restaurant interior"
              className="object-cover w-full h-full"
            />
          </motion.div>

          <motion.div
            initial={{ opacity: 0, x: 20 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.6 }}
            viewport={{ once: true }}
            className="flex flex-col justify-center"
          >
            <h2 className="heading-2 mb-6">{content[lang].title}</h2>
            <p className="text-lg text-muted-foreground mb-8">{content[lang].description}</p>
            <Button size="lg" className="btn-primary self-start">
              {content[lang].cta}
            </Button>
          </motion.div>
        </div>
      </div>
    </section>
  );
};
