<?php 
		require("header.php");
?>
  <main class="main-content position-relative border-radius-lg ">
    <!-- Navbar -->
   <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl " id="navbarBlur" data-scroll="false">
      <div class="container-fluid py-1 px-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
            <li class="breadcrumb-item text-sm"><a class="opacity-5 text-white" href="javascript:;">Pages</a></li>
            <li class="breadcrumb-item text-sm text-white active" aria-current="page">Order Reports</li>
          </ol>
          <h6 class="font-weight-bolder text-white mb-0">Reports</h6>
        </nav>
        <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
          <ul class="navbar-nav  justify-content-end">
          
            <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
              <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                </div>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>

    <div class="container-fluid py-4">
      <h2 class="text text-white">Order Reports</h2>
  
          <form method="GET">
        <div class="row">
      <div class="mb-3 col-md-4">
        <label for="filterDate" class="form-label">From:</label>
        <input type="date" id="from" name="date" class="form-control" required>
        </div>
          <div class="mb-3 col-md-4">
        <label for="filterDate" class="form-label">To:</label>
        <input type="date" id="to" name="date" class="form-control" required>
        </div>
        </div>
        <input type="submit" name="submit" value="Search" class="btn btn-light search">
        </form>
      
      <div class="row my-4">
        <div class="col-12">
          <div class="card mb-4">
            <div class="card-header pb-0">
              <h6>Orders</h6>
            </div>
            <div class="card-body px-0 pt-0 pb-2">
              <div class="table-responsive p-0 container1">
                <table class="table align-items-center mb-0" id="order-table">
                  <thead>
                    <tr>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Date</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Order Time</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"> Customer Name</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"> Customer Phone Number</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order City</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Price</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Delivery Charge</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Total</th>
                      <th class="text-secondary opacity-7"></th>

                    </tr>
                  </thead>
                  <tbody>
                      <tr>
                        <td class="align-middle ">
                          <p class="text-m text-secondary mb-0" id="date"></p>
                        </td>
                        <td class="align-middle text-center">
                          <p class="text-s font-weight-bold mb-0" id="time"></p>
                        </td>
                        <td class="align-middle text-center text-sm">
                          <p class="text-m text-secondary mb-0" id="name"></p>
                        </td>
                        <td class="align-middle text-center">
                        <p class="text-m text-secondary mb-0" id="phone"></p>
                        </td>
                        <td class="align-middle text-center">
                          <p class="text-m text-secondary mb-0" id="city"></p>
                        </td>
                        <td class="align-middle text-center">
                          <p class="text-m text-secondary mb-0" id="price"></p>
                        </td>
                      </tr>
          </tbody>
          </table>
          </div>
        </div>
      </div>
    </div>
    </div>
    


    <div class="row">
        <div class="col-sm-3">
            <p class="text-lg font-weight-bolder">Total Orders:</p>
        </div>
        <div class="col-sm-1">
            <p id="orderCount" class="font-weight-bolder text-primary"></p>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-3">
            <p class="text-lg font-weight-bolder">Subtotal:</p>
        </div>
        <div class="col-sm-1">
            <p id="subtotal" class="font-weight-bolder"></p>
        </div>
    </div>
      <div class="row">
        <div class="col-sm-3">
            <p class="text-lg font-weight-bolder">Delivery Charges:</p>
        </div>
        <div class="col-sm-1">
            <p id="charge" class="font-weight-bolder"></p>
        </div>
    </div>
        <div class="row">
        <div class="col-sm-3">
            <p class="text-lg font-weight-bolder">Grand Total:</p>
        </div>
        <div class="col-sm-1">
            <p id="total" class="text-success font-weight-bolder"></p>
        </div>
    </div>


    <!-- End Navbar -->
  </main>

  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/argon-dashboard.min.js?v=2.0.4"></script>

  <script>
  $(document).ready(function() {
    $('.search').on('click', function(e) {
        e.preventDefault();
        var fromDate = $('#from').val();
        var toDate = $('#to').val();

        $.ajax({
            url: 'functions/filterReport.php', // Replace with your PHP script URL
            type: 'GET',
            dataType: 'json',
            data: {
                submit: 1,
                from: fromDate,
                to: toDate
            },
           success: function(data) {
             console.log(data);
              if (data.length > 0) {
              updateOrderTable(data);
            } else {
                $('#order-table tbody').empty();
              
            }
        
},
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    });
     function updateOrderTable(data) {
    // Clear the existing table content
    $('#order-table tbody').empty();

    if (data.length > 0) {
        // Add table body
        var tbody = $('#order-table tbody');

        // Loop through the JSON data and add rows to the table
        $.each(data, function(index, order) {
    var row = '<tr>' +
        '<td class="text-center align-middle"><p class="text-m text-secondary mb-0">' + order.OrderDate + '</p></td>' +
        '<td class=""><p class="text-s font-weight-bold mb-0">' + order.OrderTime + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.UserFullName + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.UserPhoneNumber + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.OrderCity + '</p></td>' +
        '<td class="text-center"><span class="text-secondary text-m font-weight-bold text-warning">' + order.OrderPrice + '$</span></td>'+
        '<td class="text-center"><span class="text-secondary text-m font-weight-bold ">' + order.OrderDelivery + '$</span></td>'+
        '<td class="text-center"><span class="text-secondary text-m font-weight-bold text-success">' + order.TotalPrice + '$</span></td>'+
        '</tr>';
    tbody.append(row);
    var subtotal = parseFloat(order.subtotal);
    var deliveryCharges = parseFloat(order.deliveryCharges);

    // Calculate the total by adding the subtotal and delivery charges
    var grandTotal = subtotal + deliveryCharges;

    // Update text content in HTML elements
    $('#subtotal').text('$' + subtotal.toFixed(2)); // Display subtotal
    $('#orderCount').text(order.orderCount); // Display order count
    $('#charge').text('$' + deliveryCharges.toFixed(2)); // Display delivery charges
    $('#total').text('$' + grandTotal.toFixed(2)); 
});
    } else {
    $('#order-table tbody').empty();

    }
}
    
});
  </script>


</body>

</html>