<?php 
		require("header.php");
?>
  <main class="main-content position-relative border-radius-lg ">
    <!-- Navbar -->
   <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl " id="navbarBlur" data-scroll="false">
      <div class="container-fluid py-1 px-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
            <li class="breadcrumb-item text-sm"><a class="opacity-5 text-white" href="javascript:;">Pages</a></li>
            <li class="breadcrumb-item text-sm text-white active" aria-current="page">Purchase History</li>
          </ol>
          <h6 class="font-weight-bolder text-white mb-0">History</h6>
        </nav>
        <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
          <ul class="navbar-nav  justify-content-end">
          
            <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
              <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                </div>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>

    <div class="container-fluid py-4">
      <h2 class="text text-white">Order History</h2>
      <div class="row">

     
      <div class="mb-3 col-md-4">
        <label for="filterDate" class="form-label">Select Date:</label>
        <input type="date" id="datepicker" name="date" class="form-control">
        </div>
        <!--<div class="col-md-2 mb-3">-->
        <!--  <label for="selectOption">Filter Orders:</label>-->
        <!--  <select id="selectInstructor" class="form-select">-->
        <!--    <option value="" disabled selected>Filter Orders</option>-->
        <!--    <option value="lastMonth">Last Month</option>-->
        <!--    <option value="Last3Months">Last 3 Months</option>-->
        <!--    <option value="Last6Months">Last 6 Months</option>-->
        <!--    <option value="LastYear">Last year</option>-->
            <!-- Add more options as needed -->
        <!--  </select>-->
        <!--</div>-->
      </div>
      <div class="row my-4">
        <div class="col-12">
          <div class="card mb-4">
            <div class="card-header pb-0">
              <h6>Orders</h6>
            </div>
            <div class="card-body px-0 pt-0 pb-2">
              <div class="table-responsive p-0 container1">
                <table class="table align-items-center mb-0" id="order-table">
                  <thead>
                    <tr>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Price</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Order Date</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Time</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"> Customer Name</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"> Customer Phone Number</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order City</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Status</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Order Details</th>
                      <th class="text-secondary opacity-7"></th>

                    </tr>
                  </thead>
                  <tbody>

                    <?php
                    $sql = "SELECT *FROM a_orders WHERE OrderStatus='Completed' ORDER BY OrderID DESC";
                    $result = mysqli_query($con, $sql);
                    while ($row = mysqli_fetch_assoc($result)) {
                      $OrderID = $row['OrderID'];
                      $OrderPrice = $row['OrderPrice'];
                      $OrderDate = date('Y-m-d', strtotime($row['OrderDate']));
                      $OrderTime = $row['OrderTime'];
                      $OrderStatus = $row['OrderStatus'];
                      $OrderCity = $row['OrderCity'];
                      $OrderAddress = $row['OrderAddress'];
                      $UserFullName = $row['UserFullName'];
                      $UserPhoneNumber = $row['UserPhoneNumber'];
                      $UserEmail = $row['UserEmail'];
                      $OrderNotes = $row['OrderNotes'];
                    ?>
                      <tr>
                        <td class="text-center ">
                          <p class="text-m text-secondary mb-0"><?php echo $OrderPrice ?>$</p>
                        </td>
                        <td class="">
                          <p class="text-s font-weight-bold mb-0"><?php echo $OrderDate ?></p>
                        </td>
                        <td class="align-middle text-center text-sm">
                          <p class="text-m text-secondary mb-0"><?php echo $OrderTime ?></p>
                        </td>
                        <td class="align-middle text-center">
                          <span class="text-secondary text-s font-weight-bold"><?php echo $UserFullName ?></span>
                        </td>
                        <td class="align-middle text-center">
                          <span class="text-secondary text-m font-weight-bold"><?php echo $UserPhoneNumber ?></span>
                        </td>
                        <td class="align-middle text-center">
                          <span class="text-secondary text-m font-weight-bold"><?php echo $OrderCity ?></span>
                        </td>
                        <td class="align-middle text-center text-sm">
                          <span class="badge badge-sm bg-gradient-success"><?php echo $OrderStatus ?></span>
                        </td>
                        <td class="text-center">
                          <a href="#"><i class="fas fa-caret-down fa-lg pointer-cursor toggle-specifications" data-bs-toggle="collapse" data-order-id="<?php echo $OrderID ?>" data-bs-target="#order-<?php echo $OrderID ?>"></i></a>
                        </td>

                      </tr>
                      <tr>
                        <td colspan="8" class="p-0">
                          <div id="order-<?php echo $OrderID ?>" class="collapse">
                            <div>
                              <?php
                              $sql2 = "SELECT D.*,S.*,I.* FROM a_orderdetails D,a_specifications S,a_items I WHERE OrderID_FK = $OrderID AND D.D_SpecificationId_FK=S.SpecificationID AND S.ItemID_FK=I.ItemID";
                              $result2 = mysqli_query($con, $sql2);
                              ?>
                              <table class="table table-bordered">
                                <thead>
                                  <tr>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Item Name</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Specification</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Quantity</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Price Per Specification</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Total</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center"></th>
                                  </tr>
                                </thead>
                                <tbody>
                                  <?php
                                  while ($row1 = mysqli_fetch_assoc($result2)) {
                                    $SpecificationID  = $row1['SpecificationID'];
                                    $itemName = $row1['ItemName'];
                                    $description = $row1['S_description'];
                                    $qty = $row1['D_Quantity'];
                                    $item_image = $row1['ItemImage'];
                                    $imageUrLItem = "" . $item_image;
                                    $speci_price = $row1['S_price'];
                                    $speci_total = $row1['D_Total'];
                                    $speci_image = $row1['S_Image'];
                                    $imgUrlSpeci = "" . $speci_image;
                                  ?>
                                    <tr>
                                      <td class="align-middle text-center">
                                        <div class="d-flex px-2 py-1">
                                          <div>
                                            <img src="<?php echo $imageUrLItem ?>" class="avatar avatar-sm me-3" alt="Item Image">
                                          </div>
                                          <div class="d-flex flex-column justify-content-center">
                                            <h6 class="mb-0 text-sm"><?php echo $itemName ?></h6>
                                          </div>
                                        </div>
                                      </td>
                                      <td class="align-middle text-center"><?php echo $description ?></td>
                                      <td class="align-middle text-center"><?php echo $qty ?></td>
                                      <td class="align-middle text-center"><?php echo $speci_price ?>$</td>
                                      <td class="align-middle text-center"><?php echo $speci_total ?>$</td>
                        </td>
                      </tr>
                    <?php
                                  }
                    ?>
                  </tbody>
                </table>
                <hr class="my-1">
                <div class="p-3">
                  <h6 class="">Full Address: <span class="text-secondary"><?php echo $OrderAddress ?></span></h6>
                  <h6 class="">Additional Notes: <span class="text-secondary"><?php echo $OrderNotes ?></span></h6>
                  <h6 class="">Customer Email: <span class="text-secondary"><?php echo $UserEmail ?></span></h6>
                </div>

              </div>
            </div>
            </td>
            </tr>
          <?php
                    }
          ?>
          </tbody>
          </table>
          </div>
        </div>
      </div>
    </div>
    </div>
    </div>
    <!-- End Navbar -->
  </main>

  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/argon-dashboard.min.js?v=2.0.4"></script>

  <script>
    $(document).ready(function() {
      $('.updateStatus').click(function() {
        var orderID = $(this).data('order-id');
        $.ajax({
          type: "POST",
          url: "functions/updateOrderStatus.php",
          data: {
            order_id: orderID,
          },
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        })
      })
    })

   
  </script>
  <script>
    $(document).ready(function() {
      $('#datepicker').change(function() {
        var selectedDate = $(this).val();
        $.ajax({
          url: 'functions/filterOrderByDay.php',
          type: 'GET',
          data: {
            date: selectedDate
          },
          dataType: 'json',
          beforeSend: function() {
            // Show a loading spinner or message
          },
          success: function(data) {
            console.log(data);
            if (data.length > 0) {
              updateOrderTable(data);
            } else {
    $('#order-table tbody').empty();
              
            }
          },
          complete: function() {
            // Hide the loading spinner or message
          },  
          error: function() {
            // Handle errors, e.g., network issues
          }
        });
      });

      function updateOrderTable(data) {
    // Clear the existing table content
    $('#order-table tbody').empty();

    if (data.length > 0) {
        // Add table body
        var tbody = $('#order-table tbody');

        // Loop through the JSON data and add rows to the table
        $.each(data, function(index, order) {
    var row = '<tr>' +
        '<td class="text-center"><p class="text-m text-secondary mb-0">' + order.OrderPrice + '$</p></td>' +
        '<td class=""><p class="text-s font-weight-bold mb-0">' + order.OrderDate + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.OrderTime + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.UserFullName + '</p></td>' +
        '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + order.UserPhoneNumber + '</p></td>' +
        '<td class="text-center"><span class="text-secondary text-m font-weight-bold">' + order.OrderCity + '</span></td>' +
        '<td class="text-center"> <span class="badge badge-sm bg-gradient-success">' + order.OrderStatus + '</span></td>' +
        '<td class="text-center"> <a href="#"><i class="fas fa-caret-down fa-lg pointer-cursor toggle-specifications" data-bs-toggle="collapse" data-order-id="' + order.OrderID + '" data-bs-target="#order-' + order.OrderID + '"></i></a></td>' +
        '</tr>';
    tbody.append(row);
});
    } else {
    $('#order-table tbody').empty();

    }
}
    });
  </script>


</body>

</html>