<?php
header('Content-Type: application/json'); // Set the content type to JSON

include 'connect.php';

$selectedYear = isset($_GET['year']) ? $_GET['year'] : date('Y'); // Default to the current year if not specified

$monthly_orders = array(
    "Jan" => 0,
    "Feb" => 0,
    "Mar" => 0,
    "Apr" => 0,
    "May" => 0,
    "Jun" => 0,
    "Jul" => 0,
    "Aug" => 0,
    "Sep" => 0, 
    "Oct" => 0,
    "Nov" => 0,
    "Dec" => 0
);

// SQL query to fetch the total orders for each month
$sql = "SELECT MONTH(OrderDate) AS month, COUNT(*) AS total_orders 
        FROM a_orders 
        WHERE YEAR(OrderDate) = $selectedYear
        GROUP BY MONTH(OrderDate)
        ORDER BY month";

$result = $con->query($sql);

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $month = date("M", mktime(0, 0, 0, $row['month'], 1)); // Convert month number to month name
        $total_orders = $row['total_orders'];
        $monthly_orders[$month] = $total_orders;
    }
}

// Close the database connection
$con->close();

// Return the data as JSON
echo json_encode($monthly_orders);
?>
