<?php
include '../connect.php';
$filter = $_POST['filter'];
$date=date('Y-m-d');
if ($filter == 'Started Programs') {
    // Query for started programs
    $query = "SELECT P.*, I.id AS instID, I.fullName 
    FROM program P
    JOIN instructors I ON P.instructor_id = I.id
    WHERE P.startDate <= '$date' AND P.endDate >= '$date'
   ";
} else if ($filter == 'Ended Programs') {
    // Query for finished programs
    $query = "SELECT P.*, I.id AS instID, I.fullName 
    FROM program P
    JOIN instructors I ON P.instructor_id = I.id
    WHERE DATE(P.endDate) < '$date'";
} else {
    // Default query for all programs
    $query = "SELECT P.*, I.id AS instID, I.fullName 
              FROM program P
              JOIN instructors I ON P.instructor_id = I.id";
}

// Execute the SQL query
$result = mysqli_query($con,$query);
$count=mysqli_num_rows($result);
?>
<table class="table table-bordered  align-items-center mb-0">
<?php
if($count){
    ?>
<thead>
                      <tr>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Title</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Description</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Start Date</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">End Date</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Current Capacity</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Maximum Capacity</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Classroom Code</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Instructor</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Exam Link</th>
                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Delete or Edit</th>

                        <th class="text-secondary opacity-7"></th>
                      </tr>
                      <?php } else{
                    echo "Sorry, No Result found";
                  } ?>
                    </thead>
                    <tbody>
                      <?php
                    
                      while ($row = mysqli_fetch_assoc($result)) {
                        $id = $row['id'];
                        $title = $row['title'];
                        $description = $row['description'];
                        $st_date = $row['startDate'];
                        $end_date = $row['endDate'];
                        $max_capacity = $row['maxCapacity'];
                        $current_capacity = $row['currentCapacity'];
                        $code = $row['classroomCode'];
                        $instructor = $row['fullName'];
                        $link = $row['examLink'];
                      ?>
                        <tr>
                          <td>
                            <div class="d-flex flex-column justify-content-center">
                              <h6 class="mb-0 text-m"><?php echo $title ?></h6>
                            </div>
                          </td>
                          <td>
                            <p class="text-s font-weight-bold mb-0"><?php echo $description ?></p>
                          </td>
                          <td class="align-middle text-center">
                            <span class="text-secondary text-s font-weight-bold"><?php echo $st_date ?></span>
                          </td>
                          <td class="align-middle text-center">
                            <span class="text-secondary text-s font-weight-bold"><?php echo $end_date ?></span>
                          </td>
                          <td>
                            <p class="text-s font-weight-bold mb-0 text-center"><?php echo $current_capacity ?></p>
                          </td>
                          <td>
                            <p class="text-s font-weight-bold mb-0 text-center"><?php echo $max_capacity ?></p>
                          </td>
                          <td class="text-center"><?php echo $code ?></td>
                          <td>
                            <p class="text-s font-weight-bold mb-0"><?php echo $instructor ?></p>
                          </td>
                          <td class="text-center"><a href="<?php echo $link ?>" target="_blank" class="btn btn-primary">Link</a></td>
                          <td class="text-center">
                            <!-- Delete Program Icon and Modal Trigger -->
                            <a href="#" class="text-danger mx-3" data-bs-toggle="modal" data-bs-target="#deleteProgramModal<?php echo $id ?>"><i class="fas fa-trash"></i></a>
                            <!-- Edit Program Icon and Modal Trigger -->
                            <a href="#" class="text-warning" data-bs-toggle="modal" data-bs-target="#editProgramModal<?php echo $id ?>"><i class="fas fa-edit"></i></a>
                          </td>
                        </tr>

                        <!-- Modal for delete PROGRAM -->
                        <div class="modal fade" id="deleteProgramModal<?php echo $id ?>" tabindex="-1" aria-labelledby="deleteProgramModalLabel" aria-hidden="true">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="deleteProgramModalLabel">Confirm Deletion</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                              </div>
                              <div class="modal-body">
                                <p>Are you sure you want to delete the program "<?php echo $title ?>"?</p>
                              </div>
                              <div class="modal-footer">
                                <!-- Button to confirm the deletion -->
                                <button class="btn btn-danger deleteBtn" id="" data-bs-dismiss="modal" data-program-id="<?php echo $id; ?>">Delete</button>
                                <!-- Button to close the modal without deleting -->
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                              </div>
                            </div>
                          </div>
                        </div>

                        <!-- Edit Program Modal for this program -->
                        <div class="modal fade" id="editProgramModal<?php echo $id ?>" tabindex="-1" aria-labelledby="editProgramModalLabel" aria-hidden="true">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editProgramModalLabel">Edit Program</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                              </div>
                              <div class="modal-body">
                                <!-- Form for editing program details -->
                                <form id="editProgramForm<?php echo $id ?>">
                                  <div class="mb-3">
                                    <label for="editTitle" class="form-label">Title</label>
                                    <input type="text" class="form-control" id="editTitle<?php echo $id ?>" value="<?php echo $title ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label for="editDescription" class="form-label">Description</label>
                                    <textarea class="form-control" id="editDescription<?php echo $id ?>"><?php echo $description ?></textarea>
                                  </div>
                                  <div class="mb-3">
                                    <label for="editStartDate" class="form-label">Start Date</label>
                                    <input type="date" class="form-control" id="editStartDate<?php echo $id ?>" value="<?php echo $st_date ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label for="editEndDate" class="form-label">End Date</label>
                                    <input type="date" class="form-control" id="editEndDate<?php echo $id ?>" value="<?php echo $end_date ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label for="editMaxCapacity" class="form-label">Maximum Capacity</label>
                                    <input type="number" class="form-control" id="editMaxCapacity<?php echo $id ?>" value="<?php echo $max_capacity ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label for="editClassroomCode" class="form-label">Classroom Code</label>
                                    <input type="text" class="form-control" id="editClassroomCode<?php echo $id ?>" value="<?php echo $code ?>">
                                  </div>
                                  <div class="mb-3">
                                    <label for="editExamLink" class="form-label">Exam Link</label>
                                    <input type="text" class="form-control" id="editExamLink<?php echo $id ?>" value="<?php echo $link ?>">
                                  </div>
                                </form>
                              </div>
                              <div class="modal-footer">
                                <!-- Button to save the edited program -->
                                <button type="button" class="btn btn-primary Editbtn" data-bs-dismiss="modal" data-program-id="<?php echo $id; ?>">Save</button>
                                <!-- Button to close the modal without saving changes -->
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                              </div>
                            </div>
                          </div>
                        </div>

                      <?php
                      }
                      ?>
                    </tbody>
</table>