<?php 
		require("header.php");
?>
  <main class="main-content position-relative border-radius-lg ">
    <!-- Navbar -->
   <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl " id="navbarBlur" data-scroll="false">
      <div class="container-fluid py-1 px-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
            <li class="breadcrumb-item text-sm"><a class="opacity-5 text-white" href="javascript:;">Pages</a></li>
            <li class="breadcrumb-item text-sm text-white active" aria-current="page">Items</li>
          </ol>
          <h6 class="font-weight-bolder text-white mb-0">Item</h6>
        </nav>
        <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
          <ul class="navbar-nav  justify-content-end">
          
            <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
              <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                </div>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <!-- End Navbar -->
    <div class="container-fluid py-4">
      <a href="" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#addInstructorModal">Add an Item</a>
      <div class="row mb-4">
        <div class="col-md-5">
          <label for="searchItems">Search for an item or category:</label>
          <div class="input-group">
            <div class="input-group">
              <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
              <input type="text" class="form-control" placeholder="Type here..." id="item-search">

            </div>
          </div>
        </div>
      


      </div>
      <div class="row">
        <div class="col-12">
          <div class="card mb-4">
            <div class="card-header pb-0">
              <h6>Items</h6>
            </div>
            <div class="card-body px-0 pt-0 pb-2">
              <div class="table-responsive p-0">
                <table class="table align-items-center mb-0" id="item-table">
                  <thead>
                    <tr class="clickable-row">
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder ">Item id</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder ">Item Name</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder  ps-2">Item Image</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder ">Show</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder o">Out Of Stock</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder o">Promotion</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder ">Category Name</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder ">Add Specifications</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder ">Delete Or Edit</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder ">Specifications</th>

                      <th class="text-secondary opacity-7"></th>
                    </tr>
                  </thead>
                  <tbody>

                    <?php
                    $categoryData = array();
                    $query1 = "SELECT * FROM a_categories";
                    $result1 = mysqli_query($con, $query1);
                    while ($row = mysqli_fetch_assoc($result1)) {
                      $categoryData[] = $row;
                    }

                    $sql = "SELECT A.*,C.* FROM a_items A,a_categories C WHERE C.CategoryID=A.CategoryID_FK";
                    $result = mysqli_query($con, $sql);
                    while ($row = mysqli_fetch_assoc($result)) {
                      $id = $row['ItemID'];
                      $itemName = $row['ItemName'];
                      $Image = $row['ItemImage'];
                      $imageUrl = "" . $Image;
                      $status = $row['ItemShow_status'];
                      $outOfStock = $row['ItemOutOfStock_status'];
                      $promotion = $row['Promotion'];
                      $categoryId = $row['CategoryID_FK'];
                      $categoryName = $row['CategoryName'];
                    ?>
                      <tr>
                        <td class="align-middle text-center">
                          <h6 class="mb-0 text-m">#<?php echo $id ?></h6>
                        </td>
                        <td>
                          <div class="d-flex px-1 py-1 item-name">
                            <h6 class="mb-0 text-m"><?php echo $itemName ?></h6>
                          </div>
                        </td>
                        <td class="align-middle">
                          <img src="<?php echo $imageUrl ?>" alt="No Image" width="50" height="50" data-bs-toggle="modal" data-bs-target="#imageModal-<?php echo $id ?>">
                        </td>
                        <td class="align-middle text-center">
                          <?php
                          if ($status == 1) {
                          ?>
                            <a href="#" class="text-success mx-3"><i class="fa-solid fa-check fa-lg"></i></a>
                          <?php } else { ?>
                            <a href="#" class="text-danger mx-3"><i class="fa-solid fa-x fa-lg"></i></a>
                          <?php } ?>
                        </td>
                        <td class="align-middle text-center">
                          <?php
                          if ($outOfStock == 1) {
                          ?>
                            <a href="#" class="text-success mx-3"><i class="fa-solid fa-check fa-lg"></i></a>
                          <?php } else { ?>
                            <a href="#" class="text-danger mx-3"><i class="fa-solid fa-x fa-lg"></i></a>
                          <?php } ?>
                        </td>
                        <td class="align-middle text-center">
                          <?php
                          if ($promotion == 1) {
                          ?>
                            <a href="#" class="text-success mx-3"><i class="fa-solid fa-check fa-lg"></i></a>
                          <?php } else { ?>
                            <a href="#" class="text-danger mx-3"><i class="fa-solid fa-x fa-lg"></i></a>
                          <?php } ?>
                        </td>
                        <td class="align-middle text-center category">
                          <span class="text-secondary text-s font-weight-bold"><?php echo $categoryName ?></span>
                        </td>
                        <td class="text-center">
                          <a href="#" class="text-success mx-3" data-bs-toggle="modal" data-bs-target="#addSpeci<?php echo $id ?>"><i class="fas fa-solid fa-plus"></i></a>
                        </td>
                        <td class="text-center">
                          <!-- Delete Item Icon and Modal Trigger -->
                          <a href="#" class="text-danger mx-3" data-bs-toggle="modal" data-bs-target="#deleteItem<?php echo $id ?>"><i class="fas fa-trash"></i></a>
                          <!-- Edit Item Icon and Modal Trigger -->
                          <a href="#" class="text-warning" data-bs-toggle="modal" data-bs-target="#editItemModal<?php echo $id ?>"><i class="fas fa-edit"></i></a>
                        </td>
                        <td class="text-center" >
                          <a href="#"><i class="fas fa-caret-down fa-lg pointer-cursor toggle-specifications" data-bs-toggle="collapse" data-item-id="<?php echo $id ?>" data-bs-target="#specifications-<?php echo $id ?>"></i></a>
                        </td>
                      </tr>

                      <!-- Modal for showing the item image  -->
                      <div class="modal fade" id="imageModal-<?php echo $id ?>" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-m">
                          <div class="modal-content">
                            <div class="modal-body text-center">
                              <img src="<?php echo $imageUrl ?>" alt="Full-size Image" width="300" height="300">
                            </div>
                          </div>
                        </div>
                      </div>
                      <tr>
                        <td colspan="10" class="p-0">
                          <div id="specifications-<?php echo $id ?>" class="collapse">
                            <div>
                              <?php
                              $sql2 = "SELECT * FROM a_specifications WHERE ItemID_FK = $id";
                              $result2 = mysqli_query($con, $sql2);
                              ?>
                              <table class="table table-bordered speciTable  align-items-center mb-0">
                                <thead>
                                  <tr>
                                    <th class="text-secondary opacity-7"></th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Description</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Cost</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Price</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Quantity</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center">Image</th>
                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder text-center"> Delete Or Edit </th>
                                  </tr>
                                </thead>
                                <tbody>
                                  <?php
                                  while ($row1 = mysqli_fetch_assoc($result2)) {
                                    $SpecificationID  = $row1['SpecificationID'];
                                    $description = $row1['S_description'];
                                    $cost = $row1['S_cost'];
                                    $s_image = $row1['S_Image'];
                                    $imageUrL = "" . $s_image;
                                    $price = $row1['S_price'];
                                    $quantity = $row1['S_quantity'];
                                  ?>
                                    <tr>
                                      <td class="align-middle text-center"></td>
                                      <td class="align-middle text-center"><?php echo $description ?></td>
                                      <td class="align-middle text-center"><?php echo $cost ?>$</td>
                                      <td class="align-middle text-center"><?php echo $price ?>$</td>
                                      <td class="align-middle text-center"><?php echo $quantity ?></td>
                                      <td class="align-middle text-center">
                                        <img src="<?php echo $imageUrL ?>" alt="" width="50" height="50" data-bs-toggle="modal" data-bs-target="#speciModal-<?php echo $SpecificationID ?>">
                                      </td>
                                      <td class="text-center">
                                        <a href="#" class="text-danger mx-3" data-bs-toggle="modal" data-bs-target="#deleteSpeci<?php echo $SpecificationID ?>">
                                          <i class="fas fa-trash"></i>
                                        </a>
                                        <a href="#" class="text-warning" data-bs-toggle="modal" data-bs-target="#editSpeciModal<?php echo $SpecificationID ?>">
                                          <i class="fas fa-edit"></i>
                                        </a>
                                      </td>
                                    </tr>


                                    <!-- Modal for showing the specificationImage image  -->
                                    <div class="modal fade" id="speciModal-<?php echo $SpecificationID ?>" tabindex="-1" aria-labelledby="speciModalLabel" aria-hidden="true">
                                      <div class="modal-dialog modal-dialog-centered modal-m">
                                        <div class="modal-content">
                                          <div class="modal-body text-center">
                                            <img src="<?php echo $imageUrL ?>" alt="Full-size Image" width="300" height="300">
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <!-- Modal for delete specifications  -->
                                    <div class="modal fade" id="deleteSpeci<?php echo $SpecificationID ?>" tabindex="-1" aria-labelledby="deleteSpeciModalLabel" aria-hidden="true">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="deleteSpeciModalLabel">Confirm Deletion</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                          </div>
                                          <div class="modal-body">
                                            <p>Are you sure you want to delete this Specification "<?php echo $description ?>"?</p>
                                          </div>
                                          <div class="modal-footer">
                                            <!-- Button to confirm the deletion -->
                                            <button class="btn btn-danger deleteBtnSpeci" id="" data-bs-dismiss="modal" data-speci-id="<?php echo $SpecificationID; ?>">Delete</button>
                                            <!-- Button to close the modal without deleting -->
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <!-- Modal for edit specifications  -->
                                    <div class="modal fade" id="editSpeciModal<?php echo $SpecificationID ?>" tabindex="-1" aria-labelledby="editSpeciModalLabel" aria-hidden="true">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="">Edit Specifications</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                          </div>
                                          <div class="modal-body">
                                            <form>
                                              <div class="mb-3">
                                                <label for="editTitle" class="form-label">Description</label>
                                                <input type="text" class="form-control" id="editSpeciDesc<?php echo $SpecificationID ?>" value="<?php echo $description ?>" required>
                                              </div>
                                              <div class="mb-3">
                                                <label for="Cost" class="form-label">Cost</label>
                                                <input type="number" id="editSpeciCost<?php echo $SpecificationID ?>" class="form-control" required value="<?php echo $cost ?>">
                                              </div>
                                              <div class="">
                                                <label for="Price" class="form-label mt-2 ">Price</label>
                                                <input type="number" id="editSpeciPrice<?php echo $SpecificationID ?>" required class="form-control" value="<?php echo $price ?>">
                                              </div>

                                              <div class="mb-3">
                                                <label for="Quantity" class="form-label ">Quantity</label>
                                                <input type="number" id="editSpeciQty<?php echo $SpecificationID ?>" class="form-control" required value="<?php echo $quantity ?>">
                                              </div>
                                              <div class="mb-3">
                                                <label for="editImage" class="form-label">Specification Image</label>
                                                <img src="<?php echo $imageUrL ?>" alt="" width="50" height="50" class="m-2">
                                                <input type="file" class="form-control" name="image" id="editSpeciImage<?php echo $SpecificationID ?>" value="<?php echo $imageUrL ?>">
                                              </div>
                                            </form>
                                          </div>
                                          <div class="modal-footer">
                                            <!-- Button to save the edited program -->
                                            <button type="button" class="btn btn-success EditbtnSpeci" data-bs-dismiss="modal" data-specii-id="<?php echo $SpecificationID; ?>">Save</button>
                                            <!-- Button to close the modal without saving changes -->
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  <?php
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </td>
                      </tr>

                      <!-- Add Speicifications -->
                      <div class="modal fade" id="addSpeci<?php echo $id ?>" tabindex="-1" aria-labelledby="addSpeciModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="addProgramModalLabel">Add Speicification For <?php echo $itemName ?></h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              <form method="POST">
                                <div class="mb-3">
                                  <label for="speciName" class="form-label">Description</label>
                                  <input type="text" class="form-control" name="speciName" id="speciName<?php echo $id ?>" required>
                                </div>
                                <div class="mb-3">
                                  <label for="category" class="form-label">Cost</label>
                                  <input type="number" id="speciCost<?php echo $id ?>" class="form-control" required>
                                </div>
                                <div class="">
                                  <label for="show" class="form-label mt-2 ">Price</label>
                                  <input type="number" id="speciPrice<?php echo $id ?>" class="form-control">
                                </div>

                                <div class="mb-3">
                                  <label for="outofstock" class="form-label ">Quantity</label>
                                  <input type="number" id="speciQty<?php echo $id ?>" class="form-control">
                                </div>
                                <div class="mb-3">
                                  <label for="image" class="form-label">Specification Image</label>
                                  <input type="file" class="form-control" id="speciImage<?php echo $id ?>" name="speciImage" value="speciImage" required>
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                  <button type="button" class="btn btn-success addSpeciBtn" data-bs-dismiss="modal" data-itemmm-id="<?php echo $id; ?>">Add</button>
                                </div>
                              </form>
                            </div>

                          </div>
                        </div>
                      </div>

                      <!-- Modal for delete Item -->
                      <div class="modal fade" id="deleteItem<?php echo $id ?>" tabindex="-1" aria-labelledby="deleteItemModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="deleteItemModalLabel">Confirm Deletion</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              <p>Are you sure you want to delete this Item "<?php echo $itemName ?>"?</p>
                            </div>
                            <div class="modal-footer">
                              <!-- Button to confirm the deletion -->
                              <button class="btn btn-danger deleteBtnItem" id="" data-bs-dismiss="modal" data-item-id="<?php echo $id; ?>">Delete</button>
                              <!-- Button to close the modal without deleting -->
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- Edit Item Modal for this ITEM -->
                      <div class="modal fade" id="editItemModal<?php echo $id ?>" tabindex="-1" aria-labelledby="editItemModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="editProgramModalLabel">Edit Item</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              <!-- Form for editing Item details -->
                              <form id="editProgramForm<?php echo $id ?>">
                                <div class="mb-3">
                                  <label for="editTitle" class="form-label">Item Name</label>
                                  <input type="text" class="form-control" id="editItemName<?php echo $id ?>" value="<?php echo $itemName ?>" required>
                                </div>
                                <div class="mb-3">
                                  <label for="editImage" class="form-label">Item Image</label>
                                  <img src="<?php echo $imageUrl ?>" alt="" width="50" height="50" class="m-2">
                                  <input type="file" class="form-control" name="image" id="editItemImage<?php echo $id ?>" value="<?php echo $imageUrl ?>" required>
                                </div>
                                <div class="mb-3">
                                  <label for="category" class="form-label">Category</label>
                                  <?php
                                  echo '<select class="form-select" name="category" id="editcategory' . $id . '" required>';
                                  foreach ($categoryData as $category) {
                                    $categoryNamee = $category['CategoryName'];
                                    $categoryId = $category['CategoryID'];
                                    echo '<option value="' . $categoryId . '">' . $categoryNamee . '</option>';
                                  }
                                  echo '</select>';
                                  ?>

                                </div>
                                <div class="">
                                  <label for="show" class="form-label mt-2 ">Show</label>
                                  <input type="checkbox" name="show" id="editshow<?php echo $id ?>" <?php echo ($status == 1) ? 'checked' : ''; ?>>
                                </div>
                                <div class="">
                                  <label for="outofstock" class="form-label">Out Of Stock</label>
                                  <input type="checkbox" name="outofstock" id="editoutofstock<?php echo $id ?>" <?php echo ($outOfStock == 1) ? 'checked' : ''; ?>>
                                </div>
                                <div class="mb-3">
                                  <label for="Promotion" class="form-label">Promotion</label>
                                  <input type="checkbox" name="promotion" id="editPromotion<?php echo $id ?>" <?php echo ($promotion == 1) ? 'checked' : ''; ?>>
                                </div>
                              </form>
                            </div>
                            <div class="modal-footer">
                              <!-- Button to save the edited program -->
                              <button type="button" class="btn btn-success EditbtnItem" data-bs-dismiss="modal" data-itemm-id="<?php echo $id; ?>">Save</button>
                              <!-- Button to close the modal without saving changes -->
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php
                    }
                    ?>
                  </tbody>
                </table>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- ADD NEW Item -->
    <div class="modal fade" id="addInstructorModal" tabindex="-1" aria-labelledby="addInstructorModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="addProgramModalLabel">Add Item</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="billing.php" method="POST">
              <div class="mb-3">
                <label for="itemname" class="form-label">Item Name</label>
                <input type="text" class="form-control" name="ItemName" id="ItemName" required>
              </div>
              <div class="mb-3">
                <label for="image" class="form-label">Item Image</label>
                <input type="file" class="form-control" name="image" id="image" required>
              </div>
              <div class="mb-3">
                <label for="category" class="form-label">Category</label>
                <select class="form-select" name="category" id="category" required>
                  <option value="" disabled selected>Select Category</option>
                  <?php
                  $query = "SELECT * FROM a_categories";
                  $result = mysqli_query($con, $query);
                  while ($row = mysqli_fetch_assoc($result)) {

                    $categoryName = $row['CategoryName'];
                    $categoryId = $row['CategoryID'];
                    echo '<option value="' . $categoryId . '">' . $categoryName . '</option>';
                  }
                  ?>
                </select>
              </div>
              <div class="">
                <label for="show" class="form-label mt-2 ">Show</label>
                <input type="checkbox" name="show" id="show" checked>
              </div>

              <div class="">
                <label for="outofstock" class="form-label ">Out Of Stock</label>
                <input type="checkbox" name="outofstock" id="outofstock">
              </div>

              <div class="mb-3">
                <label for="promotion" class="form-label ">Promotion</label>
                <input type="checkbox" name="promotion" id="promotion">
              </div>

              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <input type="submit" class="btn btn-primary" name="submit" value="Submit" id="submitbtn">
              </div>
            </form>
          </div>

        </div>
      </div>
    </div>

    <!-- Add Speicifications -->

  </main>

  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/argon-dashboard.min.js?v=2.0.4"></script>

  <script>
    //To add an item
    $(document).ready(function() {
      $("#submitbtn").on("click", function(e) {
        e.preventDefault();

        var itemName = $("#ItemName").val();
        var ItemImage = $("#image")[0].files[0];
        var catID = $("#category").val();
        var isShowChecked = $("#show").prop("checked");
        var isOutChecked = $("#outofstock").prop("checked");
        var isPromotion = $("#promotion").prop("checked");
        var outValue = isOutChecked ? 1 : 0;
        var showValue = isShowChecked ? 1 : 0;
        var promotion = isPromotion ? 1 : 0;

        var formData = new FormData();
        formData.append("itemName", itemName);
        formData.append("itemImage", ItemImage);
        formData.append("catID", catID);
        formData.append("show", showValue);
        formData.append("out", outValue);
        formData.append("promotion", promotion);
        $.ajax({
          url: "functions/addItems.php",
          method: "POST",
          data: formData,
          processData: false,
          contentType: false,
          success: function(response) {
            location.reload();

          },
          error: function(xhr, status, error) {
            // Handle errors
            console.error(error);
          }
        });
      });
    });

    //Delete an item
    $(document).ready(function() {
      $('.deleteBtnItem').click(function() {
        var itemId = $(this).data('item-id');
        $.ajax({
          type: "POST",
          url: "functions/deleteItem.php",
          data: {
            item_id: itemId,
          },
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        })
      })
    })

    //Edit an item
    $(document).ready(function() {
      $('.EditbtnItem').click(function() {
        var itemID = $(this).data('itemm-id');
        var editName = $('#editItemName' + itemID).val();
        var editImage = $('#editItemImage' + itemID)[0].files[0];
        var editCategory = $('#editcategory' + itemID).val();
        var isShowCheckedd = $("#editshow" + itemID).prop("checked");
        var isOutCheckedd = $("#editoutofstock" + itemID).prop("checked");
        var isPromotion = $("#editPromotion" + itemID).prop("checked");
        var outValuee = isOutCheckedd ? 1 : 0;
        var showValuee = isShowCheckedd ? 1 : 0;
        var promotion = isPromotion ? 1 : 0;

        var formData = new FormData();
        formData.append("itemID", itemID);
        formData.append("itemName", editName);
        formData.append("itemImage", editImage);
        formData.append("catID", editCategory);
        formData.append("show", showValuee);
        formData.append("out", outValuee);
        formData.append("promotion", promotion);

        $.ajax({
          type: "POST",
          url: "functions/updateItems.php",
          processData: false,
          contentType: false,
          data: formData,
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        });
      });
    });

    //Add Specification
    $(document).ready(function() {
      $('.addSpeciBtn').click(function() {
        var itemID = $(this).data('itemmm-id');
        var speciName = $('#speciName' + itemID).val();
        var speciCost = $('#speciCost' + itemID).val();
        var speciPrice = $('#speciPrice' + itemID).val();
        var speciQty = $('#speciQty' + itemID).val();
        var speciImage = $('#speciImage' + itemID)[0].files[0];

        var formData = new FormData();
        formData.append("itemID", itemID);
        formData.append("speciName", speciName);
        formData.append("speciCost", speciCost);
        formData.append("speciPrice", speciPrice);
        formData.append("speciQty", speciQty);
        formData.append("speciImage", speciImage);

        $.ajax({
          type: "POST",
          url: "functions/addSpecifications.php",
          processData: false,
          contentType: false,
          data: formData,
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        });
      });
    });

    //Edit Specifications
    $(document).ready(function() {
      $('.EditbtnSpeci').click(function() {
        var specificationID = $(this).data('specii-id');
        var editSpeciName = $('#editSpeciDesc' + specificationID).val();
        var editSpeciCost = $('#editSpeciCost' + specificationID).val();
        var editSpeciPrice = $('#editSpeciPrice' + specificationID).val();
        var editSpeciQty = $('#editSpeciQty' + specificationID).val();
        var editSpeciImage = $('#editSpeciImage' + specificationID)[0].files[0];

        var formData = new FormData();
        formData.append("speci_id", specificationID);
        formData.append("speciName", editSpeciName);
        formData.append("speciCost", editSpeciCost);
        formData.append("speciPrice", editSpeciPrice);
        formData.append("speciQty", editSpeciQty);
        formData.append("speciImage", editSpeciImage);

        $.ajax({
          type: "POST",
          url: "functions/updateSpecifications.php",
          processData: false,
          contentType: false,
          data: formData,
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        });
      });
    });

    //Delete Specification
    $(document).ready(function() {
      $('.deleteBtnSpeci').click(function() {
        var speciID = $(this).data('speci-id');
        $.ajax({
          type: "POST",
          url: "functions/deleteSpecifications.php",
          data: {
            speci_id: speciID,
          },
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        })
      })
    })

    //Filter Items by Status
    $(document).ready(function() {
      $('#selectStatus').change(function() {
        var value = $('#selectStatus').val();
        if (value === '0') {
          $.ajax({
            type: 'POST',
            url: "functions/getItemsByStatus.php",
            data: {
              show_status: 0
            },
            success: function(data) {
              console.log(data);
              if (data.length > 0) {
                updateOrderTable(data);
              } else {
                $('#item-table tbody').empty();
              }
            }
          });
        } else if (value === '1') {
          $.ajax({
            type: 'POST',
            url: "functions/getItemsByStatus.php",
            data: {
              show_status: 1
            },
            success: function(data) {
              console.log(data);
              if (data.length > 0) {
                updateOrderTable(data);
              } else {
                $('#item-table tbody').empty();
              }
            }
          });
        } else if (value === 'outofstock') {
          $.ajax({
            type: 'POST',
            url: "functions/getItemsByStatus.php",
            data: {
              outofstock_status: 1
            },
            success: function(data) {
              console.log(data);
              if (data.length > 0) {
                updateOrderTable(data);
              } else {
                $('#item-table tbody').empty();
              }
            }
          });
        }
      });

      function updateOrderTable(data) {
        // Clear the existing table content
        $('#item-table tbody').empty();

        if (data.length > 0) {
          // Add table body
          var tbody = $('#item-table tbody');

          // Loop through the JSON data and add rows to the table
          $.each(data, function(index, item) {

            var row = '<tr>' +
              '<td class="align-middle text-center"> <h6 class="mb-0 text-m">#' + item.ItemID + '</h6></td>' +
              '<td class=""><div class="d-flex px-1 py-1 item-name"><h6 class="mb-0 text-m">' + item.ItemName + '</h6></div></td>' +
              '<td class="align-middle"><img src="' + item.ItemImage + '" alt="No Image" width="50" height="50" data-bs-toggle="modal" data-bs-target="#imageModal-' + item.ItemID + '"></td>' +
              '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + item.ItemShow_status + '</p></td>' +
              '<td class="text-center"><p class="text-s font-weight-bold mb-0">' + item.ItemOutOfStock_status + '</p></td>' +
              '<td class="text-center"><span class="text-secondary text-m font-weight-bold">' + item.CategoryID_FK + '</span></td>' +
              '<td class="text-center"> <span class="badge badge-sm bg-gradient-success">' + item.OrderStatus + '</span></td>' +
              '<td class="text-center"> <a href="#"><i class="fas fa-caret-down fa-lg pointer-cursor toggle-specifications" data-bs-toggle="collapse" data-order-id="' + order.OrderID + '" data-bs-target="#order-' + order.OrderID + '"></i></a></td>' +
              '</tr>';
            tbody.append(row);
          });
        } else {
          $('#item-table tbody').empty();

        }
      }
    });

    $(document).ready(function() {
    $('.toggle-specifications').on('click', function() {
        const itemId = $(this).data('item-id');
        const $specificationDiv = $('#specifications-' + itemId);

        $specificationDiv.collapse('toggle');
    });
});
$(document).ready(function() {
    const $searchInput = $('#item-search');
    const $mainRows = $('.table tbody tr:not(:has(.speciTable))'); // Only main item rows

    $searchInput.on('input', function() {
        const searchTerm = $searchInput.val().trim().toLowerCase();

        $mainRows.each(function() {
            const $row = $(this);
            const itemName = $row.find('.item-name h6').text().trim().toLowerCase();
            const categoryName = $row.find('.category .text-secondary').text().trim().toLowerCase();

            if (itemName.includes(searchTerm) || categoryName.includes(searchTerm)) {
                $row.show();
            } else {
                $row.hide();
            }
        });
    });

    $('.toggle-specifications').on('click', function() {
        const itemId = $(this).data('item-id');
        const $specificationDiv = $('#specifications-' + itemId);

        $specificationDiv.collapse('toggle');
    });
});


  </script>



</body>

</html>