<?php 
		require("header.php");
?>
  <main class="main-content position-relative border-radius-lg ">
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl " id="navbarBlur" data-scroll="false">
      <div class="container-fluid py-1 px-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
            <li class="breadcrumb-item text-sm"><a class="opacity-5 text-white" href="javascript:;">Pages</a></li>
            <li class="breadcrumb-item text-sm text-white active" aria-current="page">Catetories</li>
          </ol>
          <h6 class="font-weight-bolder text-white mb-0">Category</h6>
        </nav>
        <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
          <ul class="navbar-nav  justify-content-end">
          
            <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
              <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                  <i class="sidenav-toggler-line bg-white"></i>
                </div>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <!-- End Navbar -->
    <div class="container-fluid py-4">
      <button class="btn btn-light" data-bs-toggle="modal" data-bs-target="#addCategoryModal">Add New Category</button>
      <div class="row">
        <div class="col-12">
          <div class="card mb-4">
            <div class="card-header pb-0">
              <h6>Categories</h6>
            </div>
            <div class="card-body px-0 pt-0 pb-2">
              <div class="table-responsive p-0">
                <table class="table align-items-center mb-0">
                  <thead>
                    <tr>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Category Name</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Category Image</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Category Color</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Edit Or Delete</th>

                    </tr>
                  </thead>
                  <tbody>

                    <?php
                    $sql = "SELECT*FROM a_categories";
                    $result = mysqli_query($con, $sql);
                    while ($row = mysqli_fetch_assoc($result)) {
                      $id = $row['CategoryID'];
                      $name = $row['CategoryName'];
                      $image = $row['CategoryImage'];
                      $imageURL =  $image;
                      $color = $row['CategoryColor'];
                    ?>
                      <tr>
                        <td>
                          <div class="d-flex px-2 py-1">
                            <div class="d-flex flex-column justify-content-center">
                              <p class="text-m text-bold mb-0"><?php echo $name ?></p>
                            </div>
                          </div>
                        </td>
                        <td>
                          <img src="<?php echo $imageURL ?>" alt="Error displaying the image" width="50" height="50"  data-bs-toggle="modal" data-bs-target="#catModal-<?php echo $id ?>">
                        </td>
                        <td class="align-middle text-center text-sm">
                          <?php
                          echo '<span class="badge badge-sm" style="background-color: ' . $color . ';">' . $color . '</span>';
                          ?>

                        </td>
                        <td class="text-center">
                          <!-- Delete Item Icon and Modal Trigger -->
                          <a href="#" class="text-danger mx-3" data-bs-toggle="modal" data-bs-target="#deleteCategory<?php echo $id ?>"><i class="fas fa-trash"></i></a>
                          <!-- Edit Item Icon and Modal Trigger -->
                          <a href="#" class="text-warning" data-bs-toggle="modal" data-bs-target="#editCategory<?php echo $id ?>"><i class="fas fa-edit"></i></a>
                        </td>
                      </tr>

                      <div class="modal fade" id="deleteCategory<?php echo $id ?>" tabindex="-1" aria-labelledby="deleteICategoryModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="deleteInstructorModalLabel">Confirm Deletion</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              <p>Are you sure you want to delete this Category? "<?php echo $name ?>"?</p>
                            </div>
                            <div class="modal-footer">
                              <!-- Button to confirm the deletion -->
                              <button class="btn btn-danger deleteBtnCat" id="" data-bs-dismiss="modal" data-category-id="<?php echo $id; ?>">Delete</button>
                              <!-- Button to close the modal without deleting -->
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                          </div>
                        </div>
                      </div>



                      <!-- Modal for showing the category image  -->
                      <div class="modal fade" id="catModal-<?php echo $id ?>" tabindex="-1" aria-labelledby="speciModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-m">
                          <div class="modal-content">
                            <div class="modal-body text-center">
                              <img src="<?php echo $imageURL ?>" alt="Full-size Image" width="300" height="300">
                            </div>
                          </div>
                        </div>
                      </div>

                      <!-- Edit Item Modal for this ITEM -->
                      <div class="modal fade" id="editCategory<?php echo $id ?>" tabindex="-1" aria-labelledby="editCategoryModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="editProgramModalLabel">Edit Category</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              <!-- Form for editing Item details -->
                              <form id="editProgramForm<?php echo $id ?>">
                                <div class="mb-3">
                                  <label for="editTitle" class="form-label">Category Name</label>
                                  <input type="text" class="form-control" id="editCategoryName<?php echo $id ?>" value="<?php echo $name ?>">
                                </div>
                                <div class="mb-3">
                                  <label for="editImage" class="form-label">Category Image</label>
                                  <img src="<?php echo $imageURL ?>" alt="" width="50" height="70">
                                  <input type="file" class="form-control " id="editImage<?php echo $id ?>" value="<?php echo $imageURL ?>">
                                </div>
                                <div class="mb-3">
                                  <label for="editColor" class="form-label">Color</label>
                                  <input type="color" class="form-control" id="editColor<?php echo $id ?>" value="<?php echo $color ?>">
                                </div>
                              </form>
                            </div>
                            <div class="modal-footer">
                              <!-- Button to save the edited category -->
                              <button type="button" class="btn btn-success EditbtnCategory" data-bs-dismiss="modal" data-cat-id="<?php echo $id; ?>">Save</button>
                              <!-- Button to close the modal without saving changes -->
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>

    <!-- Modal -->
    <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="">Add New Category</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form>
              <div class="form-group">
                <label for="categoryName">Category Name:</label>
                <input type="text" class="form-control" id="categoryName">
              </div>
              <div class="form-group">
                <label for="categoryImage">Category Image:</label><br>
                <input type="file" class="form-control-file" id="categoryImage">
                <p class="text-warning text-xs">Note that only PNG images are allowed and the size should be</p>
              </div>
              <div class="form-group">
                <label for="categoryColor">Category Color:</label>
                <input type="color" class="form-control" id="categoryColor">
              </div>
              <!-- Add other form fields similar to your example -->
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <input type="submit" class="btn btn-success" name="submit" value="Submit" id="submitbtn">
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>



    </div>
  </main>

  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/argon-dashboard.min.js?v=2.0.4"></script>


  <script>
    $(document).ready(function() {
      $("#submitbtn").on("click", function(e) {
        e.preventDefault();

        var categoryName = $("#categoryName").val();
        var categoryImage = $("#categoryImage")[0].files[0];
        var categoryColor = $("#categoryColor").val();

        var formData = new FormData();
        formData.append("categoryName", categoryName);
        formData.append("categoryImage", categoryImage);
        formData.append("categoryColor", categoryColor);
        $.ajax({
          url: "functions/addCategory.php",
          method: "POST",
          data: formData,
          processData: false,
          contentType: false,
          success: function(response) {
              location.reload();
          },
          error: function(xhr, status, error) {
            // Handle errors
            console.error(error);
          }
        });
      });
    });

    $(document).ready(function() {
      $('.deleteBtnCat').click(function() {
        var catID = $(this).data('category-id');
        $.ajax({
          type: "POST",
          url: "functions/deleteCategory.php",
          data: {
            cat_id: catID,
          },
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            console.error(xhr);
          }
        })
      })
    })


    $(document).ready(function() {
      $('.EditbtnCategory').click(function() {
        var catID = $(this).data('cat-id');
        var catName = $('#editCategoryName' + catID).val();
        var catImage = $('#editImage' + catID)[0].files[0];
        var catColor = $('#editColor' + catID).val();

        var formData = new FormData();
        formData.append("cat_id", catID);
        formData.append("categoryName", catName);
        formData.append("categoryImage", catImage);
        formData.append("categoryColor", catColor);

        alert(formData);
        $.ajax({
          type: "POST",
          url: "functions/updateCategory.php",
          data: formData,
          processData: false,
          contentType: false,
          success: function(data) {
            location.reload();
          },
          error: function(xhr, status, error) {
            alert(error);
          }
        })
      })
    })
  </script>



 

</body>

</html>